# Exercise 03 Solution: Create a Scatterplot
# Module 5: Data Visualization with ggplot2

library(ggplot2)
library(data.table)
library(here)

vat_gap_analysis <- fread(here("r_training_datax", "data", "Final", "vat_gap_analysis.csv"))

ggplot(vat_gap_analysis, aes(x = vat_inputs, y = vat_outputs)) +
  geom_point(alpha = 0.6) +
  geom_abline(intercept = 0, slope = 1, color = "blue", linetype = "dashed") +
  labs(
    title = "VAT Inputs vs. Outputs",
    x = "VAT Inputs (USD)",
    y = "VAT Outputs (USD)",
    caption = "Blue line shows equal inputs and outputs"
  ) +
  theme_minimal()
