# ==============================================================================
# Exercise 4.1 Solution: Pivot Longer Practice
# Module: Data Reshaping and Joins
# ==============================================================================

library(tidyverse)
library(here)
library(data.table)

cit_wide <- fread(here("r_training_datax", "Exercises", "data", "Intermediate", "cit_wide.csv"))

head(cit_wide)

cit_long <- cit_wide %>%
  pivot_longer(
    cols = c(cit_2020, cit_2021, cit_2022, cit_2023),
    names_to = "year",
    values_to = "cit_amount"
  )

cit_long <- cit_long %>%
  mutate(year = as.numeric(str_remove(year, "cit_")))

nrow(cit_wide)
nrow(cit_long)
nrow(cit_long) / nrow(cit_wide)

fwrite(cit_long, here("r_training_datax", "Exercises", "data", "Intermediate", "cit_long.csv"))
