# Exercise 01: Create a Grouped Bar Chart
# Module 5: Data Visualization with ggplot2

# Load required libraries
library(ggplot2)
library(data.table)
library(here)

# Load data
vat_gap_analysis <- fread(here("r_training_datax", "data", "Final", "vat_gap_analysis.csv"))

# Task: Create a grouped bar chart showing VAT collection by industry and firm size
# 
# Requirements:
# 1. Aggregate data: total actual_vat by industry AND firm_size
# 2. Create bar chart with industry on x-axis, total_vat on y-axis
# 3. Use fill = firm_size to color bars by firm size
# 4. Add position = "dodge" to make bars side-by-side
# 5. Make horizontal with coord_flip()
# 6. Add proper labels and theme_minimal()

# Step 1: Aggregate data by industry and firm_size
# Use data.table: DT[, .(total_vat = sum(actual_vat)), by = .(industry, firm_size)]


# Step 2: Create grouped bar chart
# Use aes(x = industry, y = total_vat, fill = firm_size)


# Step 3: Add geom_bar with position = "dodge"
# geom_bar(stat = "identity", position = "dodge")


# Step 4: Make horizontal with coord_flip()


# Step 5: Add labels and theme
#         - title: "VAT Collection by Industry and Firm Size"
#         - x: NULL
#         - y: "Total VAT (USD)"
#         - fill: "Firm Size"
#         - theme_minimal()


# Your complete code here:

