# ============================================================================
# Exercise 2: Vectors and Operations - TEMPLATE
# Module 1: Introduction to R
# ============================================================================

# INSTRUCTIONS:
# Complete the code below by filling in the blanks (___) and following
# the step-by-step guidance. Run each section to check your work!

# ============================================================================
# PART 1: Creating Vectors
# ============================================================================

# Step 1: Create firm_ids: "FIRM_001" through "FIRM_006"
# HINT: Use paste0() with sprintf("%03d", 1:6)
# sprintf("%03d", n) formats numbers with leading zeros
# TODO: Create the firm_ids vector
firm_ids = paste0("FIRM_", sprintf("%03d", ___))


# Step 2: Create vat_amounts with these values: 50000, 75000, NA, 90000, 45000, NA
# HINT: Use c() to combine values, NA represents missing data
# TODO: Create the vat_amounts vector
vat_amounts = c(___, ___, NA, ___, ___, NA)


# Step 3: Create years from 2020 to 2025
# HINT: Use the colon operator :
# TODO: Create the years sequence
years = ___ : ___


# Step 4: Create standard_rate - repeat 0.15 six times
# HINT: Use rep(value, times = n)
# TODO: Repeat 0.15 six times
standard_rate = rep(___, times = ___)


# Check your vectors
print(firm_ids)
print(vat_amounts)
print(years)
print(standard_rate)


# ============================================================================
# PART 2: Vector Operations
# ============================================================================

# Step 5: Calculate mean VAT (remember to handle NA!)
# HINT: Use mean() with na.rm = TRUE to remove missing values
# TODO: Calculate the mean
mean(___, na.rm = ___)


# Step 6: Calculate total VAT collected
# HINT: Use sum() with na.rm = TRUE
# TODO: Calculate the sum
sum(___, na.rm = ___)


# Step 7: Add 5% penalty - multiply all vat_amounts by 1.05
# HINT: Vector arithmetic works element-by-element
# TODO: Multiply the vector by 1.05
___ * ___


# ============================================================================
# PART 3: Indexing
# ============================================================================

# Step 8: Get the VAT amount for the 3rd firm
# HINT: Use square brackets with the position number
# TODO: Index position 3
___[___]


# Step 9: Get VAT amounts for firms 2, 4, and 5
# HINT: Use c(2, 4, 5) inside the square brackets
# TODO: Index multiple positions
___[c(___, ___, ___)]


# Step 10: Find all VAT amounts greater than 60000
# HINT: Use a logical condition inside square brackets
# Don't forget to handle NA values with !is.na()
# TODO: Filter using logical indexing
vat_amounts[___ > ___ & !is.na(___)]


# ============================================================================
# PART 4: Missing Data
# ============================================================================

# Step 11: How many firms haven't declared VAT?
# HINT: is.na() returns TRUE for missing values, sum() counts TRUEs
# TODO: Count missing values
sum(is.na(___))


# Step 12: Create a logical vector showing which firms have missing data
# HINT: Use is.na() on vat_amounts
# TODO: Identify missing values
is.na(___)


# Step 13: Which firm IDs correspond to missing VAT data?
# HINT: Use firm_ids[is.na(vat_amounts)]
# TODO: Get firm IDs with missing data
___[is.na(___)]


# ============================================================================
# CONGRATULATIONS!
# You've completed Exercise 2. Make sure all your code runs without errors.
# Compare your results with the solution script when you're done.
# ============================================================================
